(function initAbtestUtil(params) {
    let abtestUtil = {};

    /**
     * 将字符串信息传递给父组件
     */
    abtestUtil.sendVariableToParent = function (data) {
        // 无父窗口，则不传
        if (window.parent === window) {
            return;
        }
        let _data = JSON.stringify(data);

        // 非第一次向父页面发送数据 || （父组件传入空对象 && 页面表单变量有默认值）
        if (!abtestUtil.tmp) {
            console.log('将信息传递给父组件', _data)
            window.parent.postMessage(_data);
        }

        // 第一次向父页面发送数据 && !（父组件传入空对象 && 页面表单变量有默认值）
        if (abtestUtil.tmp) {
            // 传给父页面数据与父页面传入数据相同
            if (_data === abtestUtil.tmp) {
                // 不做处理
            }else{
                console.log('将信息传递给父组件', _data)
                window.parent.postMessage(_data);
            }
            // 第二次向父页面发送数据及以后不做判断
            abtestUtil.tmp = undefined;
        }
    }

    /**
     * 子组件接收信息；初始值父组件会传"{}"
     */
    abtestUtil.receiveVariableFromParent = function (event, form) {
        // console.log('接收父组件信息', event.data)
        let _data = JSON.parse(event.data);

        // 父组件传入空对象 && 页面表单变量有默认值，把默认值传给父页面
        if (Object.keys(_data).length === 0 && !!form) {
            abtestUtil.sendVariableToParent(form);
            return form;
        }

        // 标记临时变量，规避子页面用类似vue.watch实现的数据监视回传问题
        abtestUtil.tmp = event.data; // 父页面传入的值

        // 父组件传入非空对象 || 页面表单变量无默认值
        return _data;
    }

    window.abtestUtil = abtestUtil;
}())

